# Find Post Gaps

A WordPress plugin that helps identify gaps in your posting schedule by providing calendar and list views of published content. Shows empty days where no posts were published, allowing quick draft creation to fill those gaps. The plugin displays both published posts and drafts chronologically, making it easy to spot patterns and maintain consistent posting frequency.

## Requirements
- PHP 8.2 or higher
- WordPress 6.2 or higher
- Editor or Administrator role


## Description

Find Post Gaps helps content managers maintain consistent posting schedules by providing:
- Calendar view showing published posts and drafts
- List view for chronological content review
- Quick draft creation for empty days
- Direct links to edit existing content
- Month-to-month navigation
- Post count indicators

## Key Features
1. Dual View System
   - Calendar view for visual schedule analysis
   - List view for chronological content review

2. Content Management
   - One-click draft creation
   - Direct edit links for posts and drafts
   - Post count indicators per day

3. Navigation
   - Month-to-month navigation
   - Easy view switching
   - Integrated with WordPress admin


## Installation

1. Upload 'find-post-gaps' to the '/wp-content/plugins/' directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Access via 'Post Calendar' in the admin menu
4. Ensure your user role has 'edit_posts' capability

## Developer
Jorge Pereira 

## Credits
This plugin was started in November 2024 with the help of Claude.ai (specifically the Projects feature) as a learning experience on how to create and manage code.    What an incredible tool! 

If you’re interested in writing any documentation or creating tutorials please <a href="http://jorgep.com/contact/" rel="nofollow">let me know</a>



## Changelog

### 1.1.1
- Added list view option
- Improved navigation between months
- Enhanced draft creation functionality

### 1.1.0
- Initial calendar view implementation
- Basic draft creation feature
- Post count indicators

### 1.0.0
- Plugin foundation
- Basic WordPress integration